/****************************************************************************\ 
 *** 
 *** File                  : rtosal_task.cpp
 *** 
 *** Generated by dSPACE Tools.
 *** (c) Copyright 2013, dSPACE GmbH. All rights reserved.
\****************************************************************************/

#if !defined(RTOSAL_TASK_CPP_)
#  define    RTOSAL_TASK_CPP_


/* -- Include directives. -- */
#  include <DsApplicationInterface.h>
#  include "dssimengine_api.h"
#  include "rtosal_msg.h"
#  include "rtosal_taskap.h"
#  include "IOCode_Data.h"
#  include "Bus_Configuration__1__11337.h"
#  include <dsrtt.h>
#  include "rtosal_task.h"

#  if defined(EXTERN_C_DECL)
#    undef EXTERN_C_DECL
#  endif
#  if defined(__cplusplus)
#    define EXTERN_C_DECL extern "C"
#  else
#    define EXTERN_C_DECL extern
#  endif


/* -- Defines and directives in module scope. After include directives. -- */
DS_DEFINE_TASK(DsCRtosAlPeriodic_Task_1);
DS_DEFINE_TASK(DsCRtosAlBus_Configuration);
DS_DEFINE_TASK(DsCRtosAlCAN_RX_Task_i1_);

/* -- Variable declarations in module scope. -- */
DsCTask* pRtosAlPeriodic_Task_1 = 0;
DsCTask* pRtosAlBus_Configuration = 0;
DsCTask* pRtosAlCAN_RX_Task_i1_ = 0;
DsCTimer* pRtosAlTimer_Periodic_Task_1 = 0;
DsCTimer* pRtosAlTimer_Bus_Configuration = 0;

/* Task simulation time variable */
Float64 RtosAlTaskSimTime_Periodic_Task_1 = 0;
ULong64 StepCounter_Periodic_Task_1 = 0;

/* Task simulation time variable */
Float64 RtosAlTaskSimTime_Bus_Configuration = 0;
ULong64 StepCounter_Bus_Configuration = 0;

#ifdef TASK_ENABLE_PROFILING
DsTProfilerSource ProfilerSrc_RtosAlTask_01_TaskEntry;
DsTProfilerSource ProfilerSrc_Control_system_2020_DSRTMdlOutputs0;
DsTProfilerSource ProfilerSrc_Control_system_2020_DSRTMdlUpdate0;
DsTProfilerSource ProfilerSrc_RtosAlTask_01_TaskExit;
DsTProfilerSource ProfilerSrc_RtosAl80140d8c_e6d7_917_99ec_377ac1dd6110_TaskEntry;
DsTProfilerSource ProfilerSrc_Bus_Configuration_iiBusCfg_MainFunction_11336_11334;
DsTProfilerSource ProfilerSrc_RtosAl80140d8c_e6d7_4917_99ec_377ac1dd6110_TaskExit;
DsTProfilerSource ProfilerSrc_RtosAlCAN_RX_Task_TaskEntry;
DsTProfilerSource ProfilerSrc_CAN_RX_Component_Function;
DsTProfilerSource ProfilerSrc_RtosAlCAN_RX_Task_TaskExit;
DsTProfilerSource ProfilerSrc_pRtosAlPeriodic_Task_1_daqService_1;
#endif

/* -- Declarations of extern functions. -- */

 EXTERN_C_DECL void Control_system_2020_DSRTMdlOutputs0(
    void);

 EXTERN_C_DECL void Control_system_2020_DSRTMdlUpdate0(
    void);

/* -- Declarations of module local functions. -- */

  void RtosAlHandleOverruns(
    DsCTask* pTask, int numberOfAcceptedOverruns);

/* -- Definitions of exported functions. -- */

  void
RtosAlDefaultDeadlineViolationHandler(
    DsTErrorList ErrorList, DsCTask* pTask) 
{
    SimEngineApplStop();
    DsCApplication* pAppl = SimEngineApplGet();
    char CallCounterStr[32];
    snprintf(CallCounterStr, 32, "%llu", pTask->getCallCounter());
    pAppl->errorMessage(RTOSAL_DEADLINE_VIOLATION, "%s%s%s", "Control_system_2020", pTask->getDescription(), CallCounterStr);

}

  void
RtosAlProfilerSourcesInitialization(
    ) 
{
#ifdef TASK_ENABLE_PROFILING
    ProfilerSrc_RtosAlTask_01_TaskEntry =  dsProfilerCreateSource("RtosAlTask_01_TaskEntry");
    ProfilerSrc_Control_system_2020_DSRTMdlOutputs0 =  dsProfilerCreateSource("Control_system_2020_DSRTMdlOutputs0");
    ProfilerSrc_Control_system_2020_DSRTMdlUpdate0 =  dsProfilerCreateSource("Control_system_2020_DSRTMdlUpdate0");
    ProfilerSrc_RtosAlTask_01_TaskExit =  dsProfilerCreateSource("RtosAlTask_01_TaskExit");
    ProfilerSrc_RtosAl80140d8c_e6d7_917_99ec_377ac1dd6110_TaskEntry =  dsProfilerCreateSource("RtosAl80140d8c_e6d7_4917_99ec_377ac1dd6110_TaskEntry");
    ProfilerSrc_Bus_Configuration_iiBusCfg_MainFunction_11336_11334 =  dsProfilerCreateSource("Bus_Configuration__1__BusCfg_MainFunction_11336_11334");
    ProfilerSrc_RtosAl80140d8c_e6d7_4917_99ec_377ac1dd6110_TaskExit =  dsProfilerCreateSource("RtosAl80140d8c_e6d7_4917_99ec_377ac1dd6110_TaskExit");
    ProfilerSrc_RtosAlCAN_RX_Task_TaskEntry =  dsProfilerCreateSource("RtosAlCAN_RX_Task_TaskEntry");
    ProfilerSrc_CAN_RX_Component_Function =  dsProfilerCreateSource("CAN_RX_Component_Function");
    ProfilerSrc_RtosAlCAN_RX_Task_TaskExit =  dsProfilerCreateSource("RtosAlCAN_RX_Task_TaskExit");
    ProfilerSrc_pRtosAlPeriodic_Task_1_daqService_1 =  dsProfilerCreateSource("pRtosAlPeriodic_Task_1_daqService_1");
#endif

}

/* -- Definitions of module local functions. -- */

  void
DsCRtosAlPeriodic_Task_1::onRun(
    DsTErrorList ErrorList) 
{
#   ifdef TASK_ENABLE_PROFILING
    dsProfilerWriteEvent(ProfilerSrc_RtosAlTask_01_TaskEntry, UserTimespanStart , 0, 0);
#   endif
    RtosAlTask_01_TaskEntry();
#   ifdef TASK_ENABLE_PROFILING
    dsProfilerWriteEvent(ProfilerSrc_RtosAlTask_01_TaskEntry, UserTimespanEnd , 0, 0);
#   endif

    DS_MODEL_ACCESS_WRITE(1,pRtosAlPeriodic_Task_1);
    dsrtt_script_service_pre_computation();
#   ifdef TASK_ENABLE_PROFILING
    dsProfilerWriteEvent(ProfilerSrc_Control_system_2020_DSRTMdlOutputs0, UserTimespanStart , 0, 0);
#   endif
    Control_system_2020_DSRTMdlOutputs0();
#   ifdef TASK_ENABLE_PROFILING
    dsProfilerWriteEvent(ProfilerSrc_Control_system_2020_DSRTMdlOutputs0, UserTimespanEnd , 0, 0);
#   endif
#   ifdef TASK_ENABLE_PROFILING
    dsProfilerWriteEvent(ProfilerSrc_pRtosAlPeriodic_Task_1_daqService_1, UserTimespanStart , 0, 0);
#   endif
    pRtosAlPeriodic_Task_1->daqService(1);
#   ifdef TASK_ENABLE_PROFILING
    dsProfilerWriteEvent(ProfilerSrc_pRtosAlPeriodic_Task_1_daqService_1, UserTimespanEnd , 0, 0);
#   endif

    DS_MODEL_ACCESS_READ(1,pRtosAlPeriodic_Task_1);
    dsrtt_script_service_post_computation();
#   ifdef TASK_ENABLE_PROFILING
    dsProfilerWriteEvent(ProfilerSrc_Control_system_2020_DSRTMdlUpdate0, UserTimespanStart , 0, 0);
#   endif
    Control_system_2020_DSRTMdlUpdate0();
#   ifdef TASK_ENABLE_PROFILING
    dsProfilerWriteEvent(ProfilerSrc_Control_system_2020_DSRTMdlUpdate0, UserTimespanEnd , 0, 0);
#   endif
#   ifdef TASK_ENABLE_PROFILING
    dsProfilerWriteEvent(ProfilerSrc_RtosAlTask_01_TaskExit, UserTimespanStart , 0, 0);
#   endif
    RtosAlTask_01_TaskExit();
#   ifdef TASK_ENABLE_PROFILING
    dsProfilerWriteEvent(ProfilerSrc_RtosAlTask_01_TaskExit, UserTimespanEnd , 0, 0);
#   endif

}

  void
DsCRtosAlPeriodic_Task_1::onOverrun(
    DsTErrorList ErrorList) 
{
    DsCTask* pTask = DsCRtosAlPeriodic_Task_1::getInstance();
    RtosAlHandleOverruns(pTask, 0);

}

  void
DsCRtosAlBus_Configuration::onRun(
    DsTErrorList ErrorList) 
{
#   ifdef TASK_ENABLE_PROFILING
    dsProfilerWriteEvent(ProfilerSrc_RtosAl80140d8c_e6d7_917_99ec_377ac1dd6110_TaskEntry, UserTimespanStart , 0, 0);
#   endif
    RtosAl80140d8c_e6d7_4917_99ec_377ac1dd6110_TaskEntry();
#   ifdef TASK_ENABLE_PROFILING
    dsProfilerWriteEvent(ProfilerSrc_RtosAl80140d8c_e6d7_917_99ec_377ac1dd6110_TaskEntry, UserTimespanEnd , 0, 0);
#   endif
#   ifdef TASK_ENABLE_PROFILING
    dsProfilerWriteEvent(ProfilerSrc_Bus_Configuration_iiBusCfg_MainFunction_11336_11334, UserTimespanStart , 0, 0);
#   endif
    Bus_Configuration__1__BusCfg_MainFunction_11336_11334();
#   ifdef TASK_ENABLE_PROFILING
    dsProfilerWriteEvent(ProfilerSrc_Bus_Configuration_iiBusCfg_MainFunction_11336_11334, UserTimespanEnd , 0, 0);
#   endif
#   ifdef TASK_ENABLE_PROFILING
    dsProfilerWriteEvent(ProfilerSrc_RtosAl80140d8c_e6d7_4917_99ec_377ac1dd6110_TaskExit, UserTimespanStart , 0, 0);
#   endif
    RtosAl80140d8c_e6d7_4917_99ec_377ac1dd6110_TaskExit();
#   ifdef TASK_ENABLE_PROFILING
    dsProfilerWriteEvent(ProfilerSrc_RtosAl80140d8c_e6d7_4917_99ec_377ac1dd6110_TaskExit, UserTimespanEnd , 0, 0);
#   endif

}

  void
DsCRtosAlBus_Configuration::onOverrun(
    DsTErrorList ErrorList) 
{
    DsCTask* pTask = DsCRtosAlBus_Configuration::getInstance();
    RtosAlHandleOverruns(pTask, -1);

}

  void
DsCRtosAlCAN_RX_Task_i1_::onRun(
    DsTErrorList ErrorList) 
{
#   ifdef TASK_ENABLE_PROFILING
    dsProfilerWriteEvent(ProfilerSrc_RtosAlCAN_RX_Task_TaskEntry, UserTimespanStart , 0, 0);
#   endif
    RtosAlCAN_RX_Task_TaskEntry();
#   ifdef TASK_ENABLE_PROFILING
    dsProfilerWriteEvent(ProfilerSrc_RtosAlCAN_RX_Task_TaskEntry, UserTimespanEnd , 0, 0);
#   endif
#   ifdef TASK_ENABLE_PROFILING
    dsProfilerWriteEvent(ProfilerSrc_CAN_RX_Component_Function, UserTimespanStart , 0, 0);
#   endif
    CAN_RX_Component_Function();
#   ifdef TASK_ENABLE_PROFILING
    dsProfilerWriteEvent(ProfilerSrc_CAN_RX_Component_Function, UserTimespanEnd , 0, 0);
#   endif
#   ifdef TASK_ENABLE_PROFILING
    dsProfilerWriteEvent(ProfilerSrc_RtosAlCAN_RX_Task_TaskExit, UserTimespanStart , 0, 0);
#   endif
    RtosAlCAN_RX_Task_TaskExit();
#   ifdef TASK_ENABLE_PROFILING
    dsProfilerWriteEvent(ProfilerSrc_RtosAlCAN_RX_Task_TaskExit, UserTimespanEnd , 0, 0);
#   endif

}

  void
DsCRtosAlCAN_RX_Task_i1_::onOverrun(
    DsTErrorList ErrorList) 
{
    DsCTask* pTask = DsCRtosAlCAN_RX_Task_i1_::getInstance();
    RtosAlHandleOverruns(pTask, 0);

}

  void
RtosAlHandleOverruns(
    DsCTask* pTask, int numberOfAcceptedOverruns) 
{
    /* Value -1 of numberOfAcceptedOverruns represents positive infinity */ 
    if (numberOfAcceptedOverruns < 0)
    {
        return;
    }
    if (pTask->getOverrunCounter() > (unsigned int)numberOfAcceptedOverruns)
    {
        SimEngineApplStop();
        DsCApplication* pAppl = SimEngineApplGet();
        char CallCounterStr[32];
        snprintf(CallCounterStr, 32, "%llu", pTask->getCallCounter());
        pAppl->errorMessage(RTOSAL_TASK_OVERRUN, "%s%s%s%d", "Control_system_2020", pTask->getDescription(), CallCounterStr, numberOfAcceptedOverruns);
    }

}

#endif                                 /* RTOSAL_TASK_CPP_ */
/* [EOF] */
